function [ sp ] = fct_eval_barx_undx(x,rho,bar_mu,bar_sigma,bar_lambda,til_lambda,psi,b)
%
%   use value matching at bar_x and low_x to get optimal policy
%
und_x = x(1);
bar_x = x(2);

%   construct linear system
Amat(1,1) =  exp(bar_lambda * und_x);
Amat(1,2) = -exp(til_lambda * und_x);
Amat(2,1) =  exp(bar_lambda * bar_x);
Amat(2,2) = -exp(til_lambda * bar_x);

bcon(1,1) =  -exp(und_x)/(rho-bar_mu-bar_sigma^2/2) + b/rho;
bcon(2,1) =  -exp(bar_x)/(rho-bar_mu-bar_sigma^2/2) + b/rho + psi;

en = Amat \ bcon;

e = en(1,1);
n = en(2,1);

sp(1) = e*bar_lambda*exp(bar_lambda*und_x) + exp(und_x)/(rho-bar_mu-bar_sigma^2/2) ...
        -n* til_lambda * exp(til_lambda*und_x);
    
sp(2) = e*bar_lambda*exp(bar_lambda*bar_x) + exp(bar_x)/(rho-bar_mu-bar_sigma^2/2) ...
        -n* til_lambda * exp(til_lambda*bar_x);
    

end

